/*
 * Decompiled with CFR 0.152.
 */
package com.farsight;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.jctools.maps.NonBlockingHashMapLong;

public class FarsightClientChunkManager
extends ClientChunkCache {
    private static int EXTRA_CHUNK_DATA_LEEWAY = 10;
    private final NonBlockingHashMapLong<LevelChunk> chunks = new NonBlockingHashMapLong();
    private final Long2ObjectOpenHashMap<ClientboundForgetLevelChunkPacket> unloadedOnServer = new Long2ObjectOpenHashMap();
    private final ClientLevel world;
    public ClientPacketListener packetListener = null;
    public static List<BiConsumer<ClientLevel, LevelChunk>> unloadCallback = new ArrayList<BiConsumer<ClientLevel, LevelChunk>>();
    public static List<BiConsumer<ClientLevel, LevelChunk>> loadCallback = new ArrayList<BiConsumer<ClientLevel, LevelChunk>>();
    private LevelChunk EMPTY;
    boolean unloading = false;

    public FarsightClientChunkManager(ClientLevel world) {
        super(world, 5);
        this.EMPTY = new EmptyLevelChunk((Level)world, new ChunkPos(0, 0), (Holder)world.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS));
        this.world = world;
    }

    public LevelChunk getChunk(int x, int z, ChunkStatus leastStatus, boolean create) {
        LevelChunk chunk = (LevelChunk)this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (chunk != null) {
            return chunk;
        }
        if (create) {
            return this.EMPTY;
        }
        return null;
    }

    public String gatherStats() {
        return this.chunks.size() + ", " + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.chunks.size();
    }

    public void updateViewRadius(int loadDistance) {
    }

    public LevelChunk replaceWithPacketData(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        LevelChunk levelChunk = (LevelChunk)this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (levelChunk == null) {
            levelChunk = new LevelChunk((Level)this.world, new ChunkPos(x, z));
            levelChunk.replaceWithPacketData(buf, nbt, consumer);
            this.chunks.put(ChunkPos.asLong((int)x, (int)z), (Object)levelChunk);
        } else {
            this.world.unload(levelChunk);
            levelChunk.replaceWithPacketData(buf, nbt, consumer);
        }
        this.unloadedOnServer.remove(ChunkPos.asLong((int)x, (int)z));
        this.world.onChunkLoaded(new ChunkPos(x, z));
        for (BiConsumer<ClientLevel, LevelChunk> loadCallbackEntry : loadCallback) {
            loadCallbackEntry.accept(this.world, levelChunk);
        }
        return levelChunk;
    }

    public void drop(ChunkPos pos) {
        LevelChunk chunk = (LevelChunk)this.chunks.remove(pos.toLong());
        if (chunk == null) {
            return;
        }
        for (BiConsumer<ClientLevel, LevelChunk> unloader : unloadCallback) {
            unloader.accept(this.world, chunk);
        }
        this.world.unload(chunk);
    }

    public void replaceBiomes(int x, int z, FriendlyByteBuf data) {
        LevelChunk levelChunk = (LevelChunk)this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (levelChunk != null) {
            levelChunk.replaceBiomes(data);
        }
    }

    public int getChebyshevDistance(int chunkXa, int chunkZa, int chunkXb, int chunkZb) {
        return Math.max(Math.abs(chunkXa - chunkXb), Math.abs(chunkZa - chunkZb));
    }

    public boolean delayUnload(ClientboundForgetLevelChunkPacket packet) {
        if (this.unloading) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            this.unloadedOnServer.clear();
            return false;
        }
        if (player.chunkPosition().getChessboardDistance(new ChunkPos(packet.pos().x, packet.pos().z)) > (Integer)Minecraft.getInstance().options.renderDistance().get() + EXTRA_CHUNK_DATA_LEEWAY) {
            return false;
        }
        this.unloadedOnServer.put(ChunkPos.asLong((int)packet.pos().x, (int)packet.pos().z), (Object)packet);
        ObjectIterator iterator = this.unloadedOnServer.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long chunkLong = entry.getLongKey();
            if (this.getChebyshevDistance(player.chunkPosition().x, player.chunkPosition().z, ChunkPos.getX((long)chunkLong), ChunkPos.getZ((long)chunkLong)) <= (Integer)Minecraft.getInstance().options.renderDistance().get() + EXTRA_CHUNK_DATA_LEEWAY) continue;
            this.unloading = true;
            if (this.packetListener != null) {
                this.packetListener.handleForgetLevelChunk((ClientboundForgetLevelChunkPacket)entry.getValue());
            }
            this.unloading = false;
            iterator.remove();
        }
        return true;
    }
}

